<?
	/*

	POBS - PHP Obfuscator

	January 5th, 2002

	Version: 0.93 

	For the most up-to-date documentation visit:
	http://pobs.mywalhalla.net

	This program is free software; you can redistribute it and/or 
	modify it under the terms of the GNU General Public License as
	published by the Free Software Foundation; either version 2 of the
	License, or (at your option) any later version. 

	This program is distributed in the hope that it will be useful, but
	WITHOUT ANY WARRANTY; without even the implied warranty of 
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
	General Public License for more details. 

*/

	include 'pobs-ini.inc.php';
?>	
<HTML>
<HEAD>
	<TITLE>POBS - A PHP Obfuscator</TITLE>
	<STYLE TYPE="text/css">
		body { font-family: Arial, sans serif;font-size:<? echo ($FontSize+2); ?>pt;  vertical-align: top; }
		td { font-family: Verdana, sans serif;font-size:<? echo $FontSize; ?>pt;  vertical-align: top; }
	</STYLE>
</HEAD>
<BODY>
<?
    if ( !empty($_POST) ) extract($_POST);
	  else if (!empty($HTTP_POST_VARS)) extract($HTTP_POST_VARS);

	if ( isset( $OK ) ) CheckSafeMode();

	$StartTime = time();

	$TotalFileSizeRead = 0;
	$TotalFileSizeWrite = 0;

	$ExVarArray = array();
	$FuncArray = array();
	$ConstArray = array();
	$VarArray = array();

	$LineArray = array();
	$FileArray = array();
	$UdExcVarArrayWild = array();

	if ( isset( $OK ) ) // if action parameter in querystring
	{
		if (!(is_readable($SourceDir)))
		{
			echo "Error. Source Directory ".$SourceDir." is not readable. Program will terminate<br>";
			exit;
		}

		if (!(is_writeable($TargetDir)))
		{
			echo "Error. Target Directory ".$TargetDir." is not writeable. Program will terminate<br>";
			exit;
		}

		echo	'<h3>Execute POBS : &quot;'.$SourceDir.'&quot; =&gt; &quot;'.$TargetDir.'&quot;</h3>';
		GetWildCards();
		ScanSourceFiles();

		asort( $FuncArray );
		asort( $ConstArray );
		sort( $FileArray );

		ShowArrays();
		WriteTargetFiles();
	}
		else ShowScreen();


function ShowScreen() {
	global $TimeOut, $FileExtArray, $TargetDir, $SourceDir, $UdExcFuncArray, $UdExcVarArray, $UdExcConstArray;
	global $ReplaceFunctions, $ReplaceConstants, $ReplaceVariables, $RemoveComments, $RemoveIndents, $ConcatenateLines;
	global $FilesToReplaceArray;
	
?>	
	<TABLE CELLPADDING=0 WIDTH=100% CELLSPACING=0 BORDER=0>
		<TR>
			<TD BGCOLOR=#6699CC VALIGN=TOP><A HREF="http://pobs.mywalhalla.net" TARGET=_new><IMG SRC="pobslogo.gif" HSPACE=20 WIDTH=150 HEIGHT=61 BORDER=0></A><TD>
			<TD BGCOLOR=#6699CC VALIGN=TOP><br><b>A PHP Obfuscator<br>Version 0.93</TD>
		</TR>
	</TABLE>
	<? CheckSafeMode(); ?>
	<TABLE CELLPADDING=3 WIDTH=100% CELLSPACING=0 BORDER=1 BORDERCOLOR=#000000>
		<TR><TD BGCOLOR=#6699CC VALIGN=TOP> <CENTER><DIV style="font-size:13pt"><b>Settings</DIV></CENTER></TD></TR>
		<TR><TD><CENTER>For the most up-to-date documentation, visit <A HREF="http://pobs.mywalhalla.net" TARGET="STD">http://pobs.mywalhalla.net</A></CENTER></TD></TR>
	</TABLE>
	<br>
	<TABLE CELLPADDING=3 WIDTH=100% CELLSPACING=0 BORDER=0>
		<TR>
			<TD WIDTH=60% VALIGN=TOP>
			<TABLE WIDTH=100% CELLPADDING=3 CELLSPACING=0 BORDER=1 BORDERCOLOR=#000000>
				<FORM METHOD="POST" ACTION="<? echo $GLOBALS[PHP_SELF]?>">
				<TR><TD BGCOLOR=#E6E6E6 VALIGN=TOP><b>TimeOut (sec)</b></TD></TR>
				<TR><TD><? echo $TimeOut ?></TD></TR>
				<TR><TD BGCOLOR=#E6E6E6 VALIGN=TOP><b>Source Directory</b></TD></TR>
				<TR><TD><? echo $SourceDir ?></TD></TR>
				<TR><TD BGCOLOR=#E6E6E6 VALIGN=TOP><b>Target Directory</b></TD></TR>
				<TR><TD><? echo $TargetDir ?></TD></TR>
				<TR><TD BGCOLOR=#E6E6E6 VALIGN=TOP><b>Allowed File Extensions</b></TD></TR>
				<TR><TD><? foreach($FileExtArray as $Key => $Value ) echo $Key.': '.$Value.'<br>'; ?></TD></TR>
				<TR><TD BGCOLOR=#E6E6E6 VALIGN=TOP><b>Replacements</b></TD></TR>
				<TR><TD>
					<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=2>
						<TR><TD WIDTH=100 valign="bottom">Functions</TD><TD WIDTH=10>&nbsp;</TD><TD><input type="checkbox" name="ReplaceFunctions" value="1" checked></TD></TR>
						<TR><TD valign="bottom">Constants</TD><TD WIDTH=10>&nbsp;</TD><TD><input type="checkbox" name="ReplaceConstants" value="1" checked></TD></TR>
						<TR><TD valign="bottom">Variables</TD><TD WIDTH=10>&nbsp;</TD><TD><input type="checkbox" name="ReplaceVariables" value="1"></TD></TR>
					</TABLE>
				</TD></TR>
				<TR><TD BGCOLOR=#E6E6E6 VALIGN=TOP><b>Removals</b></TD></TR>
				<TR><TD>
					<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=2>
						<TR><TD WIDTH=100 valign="bottom">Comments</TD><TD WIDTH=10>&nbsp;</TD><TD><input type="checkbox" name="RemoveComments" value="1" checked></TD></TR>
						<TR><TD valign="bottom">Indents</TD><TD WIDTH=10>&nbsp;</TD><TD><input type="checkbox" name="RemoveIndents" value="1" checked></TD></TR>
						<TR><TD valign="bottom">Returns</TD><TD WIDTH=10>&nbsp;</TD><TD><input type="checkbox" name="ConcatenateLines" value="1"></TD></TR>
					</TABLE>
				</TD></TR>
				<TR><TD BGCOLOR=#E6E6E6 VALIGN=TOP><b>File system</b></TD></TR>
				<TR><TD>
					<INPUT TYPE=CHECKBOX NAME="ReplaceNewer" CHECKED>Replace edited files only<br>
					<INPUT TYPE=CHECKBOX NAME="RecursiveScan" CHECKED>Recursive scan (into sub-directory)<br>
					<INPUT TYPE=CHECKBOX NAME="CopyAllFiles" CHECKED>Copy all files (not in allowed file extensions) from source to dest <br>
				</TD></TR>
				<TR>
					<TD BGCOLOR=#E6E6E6 ALIGN=CENTER VALIGN=TOP>
					<INPUT TYPE=SUBMIT NAME=OK VALUE="Start processing">
					</TD>
				</TR>
				</FORM>
			</TABLE>
			</TD>
			<TD WIDTH=20%>
			<TABLE CELLPADDING=3 WIDTH=100% CELLSPACING=0 BORDER=1 BORDERCOLOR=#000000>
				<TR><TD BGCOLOR=#E6E6E6 VALIGN=TOP><b>Exclude Functions</b></TD></TR>
				<TR><TD><? foreach($UdExcFuncArray as $Key => $Value ) echo $Key.': '.$Value.'<br>'; ?></TD></TR>
				<TR><TD BGCOLOR=#E6E6E6 VALIGN=TOP><b>Exclude Constants</b></TD></TR>
				<TR><TD><? foreach($UdExcConstArray as $Key => $Value ) echo $Key.': '.$Value.'<br>'; ?></TD></TR>
			</TABLE>
			</TD>
			<TD WIDTH=20%>
			<TABLE CELLPADDING=3 WIDTH=100% CELLSPACING=0 BORDER=1 BORDERCOLOR=#000000>
				<TR><TD BGCOLOR=#E6E6E6 VALIGN=TOP><b>Exclude Variables</b></TD></TR>
				<TR><TD><? foreach($UdExcVarArray as $Key => $Value ) echo $Key.': '.$Value.'<br>'; ?></TD></TR>
			</TABLE>
			</TD>
		</TR>
	</TABLE>
<?
}

function GetYesNo($Value)
{
	if ( $Value == FALSE ) return "<FONT COLOR=Red>No</FONT>";
	else return "<FONT COLOR=green>Yes</FONT>";
}

function GetWildCards() {
	// Scan UdExcVarArray and move the Variables with Wildcards (*) to a separate array
	// Separating the variables with wildcards speeds up the scanning and checking process
	global $UdExcVarArray, $UdExcVarArrayWild;
	 
	foreach( $UdExcVarArray as $Key => $Value )
	{	
		$pos = strrpos($Value, "*");
		if ( $pos !== FALSE )
		{ 
			echo "WildCardValue: ".$Value."<br>";
			array_push($UdExcVarArrayWild, str_replace("*", "", $Value));
			$UdExcVarArray[$Key]="Niets".$Key;
		}
	}
	
	echo '&nbsp;<br>';
}

function ScanSourceFiles( $path = '' )
{
	global $ExVarArray, $FuncArray, $ConstArray, $VarArray, $LineArray, $FileArray, $StdExcFileArray;
	global $SourceDir, $TargetDir, $FileExtArray, $ReplaceVariables;
	global $RecursiveScan, $CopyAllFiles; // File system option...
	global $UdExcVarArray, $UdExcVarArrayWild, $UdExcFuncArray, $UdExcConstArray; 
	
	$dir = dir( $SourceDir.$path.'/' );
	while( $FileNaam = $dir->read() )
	{
		$fileName = $path.'/'.$FileNaam;
		
		if ( is_file( $SourceDir.$fileName ) )
		{ 
			// check if file has the proper suffix
			$Suffix = substr($FileNaam,(strrpos($FileNaam, ".")+1));
			if (in_array($Suffix, $FileExtArray) && ! in_array( $FileNaam, $StdExcFileArray ) && sizeof($FileArray) < 400)
			{
				echo "<b>+ Scanning Filename: ".substr($fileName, 1)."</b><br>\n";
				array_push( $FileArray, substr($fileName, 1) );
				$LineArray = file( $SourceDir.$fileName );
				flush();
				
				for ($rgl = 0; $rgl<sizeof($LineArray); $rgl++)
				{
					$Line = trim(strtolower($LineArray[$rgl]));
					
					if ( substr($Line, 0, 9)=="function " ) // Search for Function declaration
					{ 
						$posEinde = strpos($Line, "(");
						$FunctieNaam = substr(trim($LineArray[$rgl]), 0, $posEinde);
						$FunctieNaam = trim(str_replace("function ", "", $FunctieNaam));
						if (!($FuncArray[$FunctieNaam]) and !(in_array($FunctieNaam,$UdExcFuncArray))) $FuncArray[$FunctieNaam]="F".substr(md5($FunctieNaam), 0,8);
						$FunctieTeller++;
					}
						elseif ( $ReplaceConstants && ereg( "define[ \t(]", substr($Line, 0, 7) ) ) // Search for Constant declaration 
					{
						$posStart = strpos($Line, "(");
						$posEnd = strpos($Line, ",");
						$ConstantName = substr(trim($LineArray[$rgl]), ($posStart+1), ($posEnd-$posStart-1));
						$ConstantName = str_replace('"',"",$ConstantName);
						$posDollar = strpos($ConstantName, "$"); // name of constant may not be a variable
						if ( $posDollar === FALSE && $ConstantName != 'SID' ) { // doesn't convert SID constant (PHP4)
							if (!($ConstArray[$ConstantName]) and !(in_array($ConstantName,$UdExcConstArray))) { 
								$ConstArray[$ConstantName]="C".substr(md5($ConstantName), 0,8);
							}
						}
					}
					if ( $ReplaceVariables ) SearchVars( $LineArray[$rgl] ); // *** Search Variables
				}
			}
				elseif ( $CopyAllFiles )
			{
				echo "- Copy Filename: ".substr($fileName, 1)."<br>\n";
				copy(  $SourceDir.$fileName,  $TargetDir.$fileName );
			}
		}
		else if ( $RecursiveScan && is_dir( $SourceDir.$fileName ) && $FileNaam != "." && $FileNaam != ".." )
		{
			if ( @mkdir( $TargetDir.$fileName, 0707 ) ) echo 'Creating Directory : '.$TargetDir.$fileName.'.<br>';
				else echo '- Creating Directory : '.$TargetDir.$fileName.' <FONT COLOR=orange>Warning: Creation failed.</b></FONT><br>';
			ScanSourceFiles( $fileName );
		}
	}
	$dir->close();
}

function ShowArrays() {
	global $FuncArray, $VarArray, $ConstArray, $FileArray, $UdExcVarArray, $UdExcVarArrayWild, $FunctieTeller;

	echo	'<br>&nbsp;<br><hr color="#000000" height=1 noshade><h3>Replaced elements :</h3>';

	DisplayArray( $FuncArray, "Found functions that will be replaced", $BgColor="FFF0D0");
	DisplayArray( $ConstArray, "Found constants that will be replaced", $BgColor="8DCFF4");
	$VarsArr = $VarArray;
	ksort( $VarsArr );
	DisplayArray( $VarsArr, "Found variables that will be replaced", $BgColor="89CA9D");
	DisplayArray( $UdExcVarArray, "User Defined Exclude Variables", $BgColor="BFBFBF");
	DisplayArray( $FileArray, "Scanned Files", $BgColor="FA8B68");

	echo	'<br>&nbsp;<br><hr color="#000000" height=1 noshade><h3>Number of userdefined elements to be replaced :</h3>'.
				'Functions: '.sizeof( $FuncArray ).'<br>'.
				'Variables: '.sizeof( $VarArray ).'<br>'.
				'Constants: '.sizeof( $ConstArray ).'<br>'.
				'<br>Scanned Files: '.sizeof( $FileArray ).'<br>'.
				'&nbsp;<br>';
}

function WriteTargetFiles() {
	global $FilesToReplaceArray, $FileArray, $StartTime, $TotalFileSizeRead, $TotalFileSizeWrite;
	global $ReplaceNewer, $SourceDir, $TargetDir;
	
	echo	'<h3>Check and Replacing file :</h3>'.
				'<TABLE BORDER=0 CELLSPACING=1 CELLPADDING=3><TR>';

	foreach( $FileArray as $Key => $FileName)
	{
		$ReplaceFile = TRUE;
		
		if ( $ReplaceNewer )
		{
			$FileRead = $SourceDir."/".$FileName;
			$FileWrite = $TargetDir."/".$FileName;
			if (file_exists($FileWrite)) { // *** CHECK IF SOURCEFILE IS NEWER THAN TARGETFILE 
				$FileStats = stat($FileWrite);
				$FileWriteDate = $FileStats[9];
				$FileStats = stat($FileRead);
				$FileReadDate = $FileStats[9];
				if ( $FileReadDate <= $FileWriteDate ) $ReplaceFile = FALSE;
			}
		}
			else $ReplaceFile = FALSE;
		
		echo '<TR><TD>'.$FileName.'</TD><TD>';
		if ( $ReplaceFile )
		{
			$FileStartTime = time();
			echo ': <FONT COLOR=red>Replaced</FONT>';
			ReplaceThem($FileName);
			echo ' - Elapsed Time: '.(time()-$FileStartTime).' sec.';
		}
			else echo ': <FONT COLOR=green>Not replaced</FONT> (sourcefile older than targetfile).';
		echo '</TD></TR>';
		flush();
	}

	echo 	'</TABLE>'.
				'&nbsp;<br>'.
				'&nbsp;<br><hr color="#000000" height=1 noshade><h3>Stats :</h3>'.
				'Start Time: '.$StartTime.'<br>'.
				'Finish Time: '.time().'<br>'.
				'<b>Elapsed Time: '.(time()-$StartTime).' sec</b><br>'.
				'&nbsp;<br>'.
				'<b>Total FileSize of parsed Files: '.$TotalFileSizeRead.' Bytes<br>'.
				'Total FileSize of written Files: '.$TotalFileSizeWrite.' Bytes</b><br>';
}

// ** FUNCTIONS ** 

function SearchVars($Line)
{
	global $VarArray, $StdExcVarArray, $UdExcVarArray, $UdExcVarArrayWild;
	
	while (ereg('\$([0-9a-zA-Z_]*)', $Line, $regs))
	{
		$VarName = $regs[1];
		if (!$VarArray[$VarName] and !(in_array($VarName,$StdExcVarArray)) and !(in_array($VarName,$UdExcVarArray)))
		{ 
			// check in Wildcards Array
			foreach( $UdExcVarArrayWild as $Key => $Value )
			{
				if (substr($VarName, 0, strlen($Value)) == $Value)
				{
					echo '<i>&nbsp; &nbsp; Variable with name '.$VarName.' added to $UdExcVarArray.</i><br>';
					array_push($UdExcVarArray, $VarName); // add to excluded Variables array
				}
			}
			if (!(in_array($VarName,$UdExcVarArray))) // check again in Excluded Variables Array
			{ 
				$VarArray[$VarName]="V".substr(md5($VarName), 0,8);
			}
		}
		$pos = strpos($Line, '$');
		$Length = ($pos+strlen($regs[1]));
		$Line = substr($Line, (strpos($Line,'$')+1));
	}
}

function ReplaceThem($FileName)
{
	global $VarArray,$FuncArray, $ConstArray, $SourceDir, $TargetDir, $ReplaceVariables;
	global $ReplaceConstants, $ReplaceFunctions, $RemoveIndents, $RemoveComments, $ConcatenateLines;
	
	$FileRead = $SourceDir."/".$FileName;
	$FileWrite = $TargetDir."/".$FileName;
	
	$FdRead = fopen( $FileRead, 'r' );
 	$contents = fread( $FdRead, filesize( $FileRead ) );
 	$GLOBALS['TotalFileSizeRead'] += filesize( $FileRead );
 	echo ' - Size:'.filesize( $FileRead );
 	fclose( $FdRead );
 	
	$contents = ereg_replace( "[\r\n]{2,}", "\n", $contents ); // REMOVE EMPTY LINES AND DOS "\r\n"
	$contents = ereg_replace( "[ \t]{2,}", ' ', $contents ); // REMOVE TOO MANY SPACE OR TABS (but also in output text...)

	if ($RemoveIndents) {
		$contents = ereg_replace( "\n[ \t]*", "\n", $contents);  // REMOVE INDENT TABS and SPACES
	}
	if ($RemoveComments) {
		$contents = ereg_replace( "[ \t\n]+//[^\n]*", '', $contents); // REMOVE COMMENTS //
		$contents = preg_replace( '`/\*.*?\*/`s', '', $contents); // REMOVE COMMENTS /* ... */
	}
	if ($ConcatenateLines) {
		$contents = ereg_replace( "([\{\};:])[ \t]*\n", '\1', $contents);  // CONCATENATE LINES 
	}	

	// *** REPLACE FUNCTIONNAMES
	if ( $ReplaceFunctions )
	{
		foreach( $FuncArray as $Key => $Value ) $contents = ereg_replace("([^a-zA-Z0-9_])".$Key."[ \t]*\\(","\\1".$Value."(", $contents); //werkt
	}

	// *** REPLACE VARIABLENAMES
	if ( $ReplaceVariables )
	{
		if ( stristr($contents, 'name=' ) ) {
			$ReplaceFieldnames = TRUE;
			$contents = eregi_replace('([ \r"\'])name=([\\"\']*)','\1NAME=\2', $contents); // rename input fields to upper case
		}	else $ReplaceFieldnames = FALSE;

		if ( strpos( $contents, '->') ) $ReplaceObjects = TRUE;
			else $ReplaceObjects = FALSE;

		if ( strpos( $contents, 'class') ) $ReplaceClasses = TRUE;
			else $ReplaceClasses = FALSE;

		foreach( $VarArray as $Key => $Value )
		{
			if ( strpos($contents, $Key) !== FALSE ) // to speed up things, check if variable name is, in any way, present in the file
			{
				$contents = ereg_replace('([$&])('.$Key.')([^0-9a-zA-Z_])','\1'.$Value.'\3', $contents);  // normal variables and parameters
				$contents = ereg_replace('\$(GLOBALS|HTTP_COOKIE_VARS|HTTP_POST_VARS|HTTP_GET_VARS)([ \t]*)\[(["\' \t]*)'.$Key.'(["\' \t]*)\]', '$\1[\3'.$Value.'\4]', $contents ); // var in Tabs

				$contents = ereg_replace('(setcookie|session_register|session_is_registered|session_unregister)([ \t]*)\((["\' \t]*)'.$Key.'(["\' \t]*)\)', '\1(\3'.$Value.'\4)', $contents ); // cookie or session variables

				if ($ReplaceFieldnames) $contents = ereg_replace('([ 	"\']NAME=[\\"\']*)'.$Key.'([\\ 	"\'>])','\1'.$Value.'\2', $contents); // input fields
				if ($ReplaceObjects) $contents = ereg_replace('->[ \t]*('.$Key.')([^0-9a-zA-Z_])','->'.$Value.'\2', $contents); // objects
				if ($ReplaceClasses) $contents = ereg_replace('([^0-9a-zA-Z_])class[ \t]*('.$Key.')([^0-9a-zA-Z_])','\1class '.$Value.'\3', $contents); // class declaration
			}
		}
	}
	// *** REPLACE CONSTANTNAMES
	if ( $ReplaceConstants )
	{
		foreach( $ConstArray as $Key => $Value ) $contents = ereg_replace('([^a-zA-Z0-9_\$])('.$Key.')([^a-zA-Z0-9_])', '\1'.$Value.'\3', $contents );
	}

	$FdWrite = fopen( $FileWrite, 'w' );
	$NumberOfChars = fwrite( $FdWrite, $contents );
 	fclose( $FdWrite );
	clearstatcache();
	$GLOBALS['TotalFileSizeWrite'] += filesize( $FileWrite );
}

function DisplayArray($ArrayName, $HeaderText="", $BgColor="FFF0D0")
{
	global $TableColumns;
	
	$sizeOf = sizeOf( $ArrayName );
	
	echo	'<br>'."\n".
				'<TABLE WIDTH="100%" BORDER=0 CELLSPACING=1 CELLPADDING=3 BGCOLOR="#000000"><TR><TD><FONT COLOR=#FFFFFF><b>'.$HeaderText.'</b></FONT></TD></TR></TABLE>';
	if ( $sizeOf )
	{
		if ( $sizeOf > $TableColumns ) $width = $TableColumns; else $width = $sizeOf;
		$width = 100 / $width;

		echo '<TABLE WIDTH="100%" BORDER=0 CELLSPACING=1 CELLPADDING=3 BGCOLOR="#000000"><TR>';
	
		$Cnt = 0;
		$Line = 0;
		foreach( $ArrayName as $Key => $Value )
		{	
			$Cnt++;
			echo '<TD WIDTH="'.$width.'%" BGCOLOR="#'.$BgColor.'"><b>'.$Key.'</b><br>'.$Value.'</TD>';
			if ( ( $Cnt % $TableColumns) == 0  && ( $Cnt != $sizeOf ) )
			{
				echo '</TR>';
				echo '<TR>';
				$Line ++;
			}
		}
		$i = $Cnt % $TableColumns;
		if ( $i && $Line ) for ( ; $i < $TableColumns; $i++ ) echo '<TD BGCOLOR=#'.$BgColor.'>&nbsp;</TD>';
		
		echo '</TR></TABLE>'."\n";
		flush();
	}
		else echo '<i>No match or no replace requested</i><br>';
}

function CheckSafeMode()
{
	global $TimeOut;

	$SafeMode = strtolower(get_cfg_var("safe_mode"));
	if (!$SafeMode) set_time_limit($TimeOut);
		else echo "<b><FONT COLOR=orange>Warning: SafeMode is on. Can not set timeout.</b></FONT><br>"; 
}

?>

</BODY>
</HTML>